set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 7

**1. Preparing data
use $path_in\KLEMS_b2008_pat_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Define patent counts variable
	gen lnpat_usnonus=lnpat_nonusinv if country=="USA"
	replace lnpat_usnonus=lnpat_usinv if country!="USA"

	*Set productivity measure as patent counts
	local LP lnpat_usnonus
	
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
		replace D1_LP1_EMP=. if D1_lnTFPva_oth==. /*set patents to missing if leave-out TFP not observed for that country*/


	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
	*Standardizing patenting variable
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	

**2. Table 7, panel A
	cap program drop storeestimates	
	program define storeestimates
	est store T7_$col
		cap lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP
		cap estimates store pat_$col
	end
	
	local patents	"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP"
	local controls1	"i.country"
	local controls2	"i.country i.year"	
	local controls3	"i.country*i.bcycle i.country*year i.year"	
	local controls4	"i.country*i.year"	
	
		
	**Column 1
		global col=1
		qui xi:reg D1_lnTFPva_oth `patents' `controls1' [w=weight_VA_c], clus(ic) 
		storeestimates
		
	**Column 2
		global col=2
		qui xi:reg D1_lnTFPva_oth `patents' `controls2' [w=weight_VA_c], clus(ic) 
		storeestimates	
		
	**Column 3
		global col=3
		qui xi:reg D1_lnTFPva_oth `patents' `controls3' [w=weight_VA_c], clus(ic) 
		storeestimates
		
	**Column 4
		global col=4
		qui xi:reg D1_lnTFPva_oth `patents' `controls4' [w=weight_VA_c], clus(ic) 
		storeestimates
		 
	*Table
	esttab T7_1 T7_2 T7_3 T7_4, keep(D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP) b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
	
	foreach var in pat {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 7, panel A")
		}	
	
	
**3. Preparing data
use $path_in\KLEMS_b2008_pat_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Set productivity measure as patent citations
	local LP lncityr_usnonus
	
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
		replace D1_LP1_EMP=. if D1_lnTFPva_oth==. /*set patents to missing if leave-out TFP not observed for that country*/

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
	*Standardizing patenting variable
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	

**4. Table 7, panel B
	cap program drop storeestimates	
	program define storeestimates
	est store T7_$col
		cap lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP
		cap estimates store pat_$col
	end
	
	local patents	"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP"
	local controls1	"i.country"
	local controls2	"i.country i.year"	
	local controls3	"i.country*i.bcycle i.country*year i.year"	
	local controls4	"i.country*i.year"	
	

	**Column 1
		global col=1
		qui xi:reg D1_lnTFPva_oth `patents' `controls1' [w=weight_VA_c], clus(ic) 
		storeestimates
		
	**Column 2
		global col=2
		qui xi:reg D1_lnTFPva_oth `patents' `controls2' [w=weight_VA_c], clus(ic) 
		storeestimates	
		
	**Column 3
		global col=3
		qui xi:reg D1_lnTFPva_oth `patents' `controls3' [w=weight_VA_c], clus(ic) 
		storeestimates
		
	**Column 4
		global col=4
		qui xi:reg D1_lnTFPva_oth `patents' `controls4' [w=weight_VA_c], clus(ic) 
		storeestimates
		 
	*Table
	esttab T7_1 T7_2 T7_3 T7_4, keep(`patents') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
	
	foreach var in pat {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 7, panel B")
		}	
